package ga.view.interfaces;

import ga.core.individual.IIndividual;

import com.jme3.asset.AssetManager;
import com.jme3.scene.Spatial;

/**
 * Interface for a phenotype generator. This is the decoder function that
 * creates phenotypes from genotypes.
 * 
 * @param <T>
 *          The generic type of individuals.
 * @param <N>
 *          The generic type of phenotypes (JME spatials).
 * 
 * @since 11.08.2012
 * @author Stephan Dreyer
 */
public interface IPhenotypeGenerator<T extends IIndividual<T>, N extends Spatial> {

  /**
   * Creates a phenotype from a genotype. (Decode function)
   * 
   * @param individual
   *          Individual that contains the genotype.
   * @return Phenotype as JME spatial.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public N createPhenotype(T individual);

  /**
   * Setter for the asset manager.
   * 
   * @param assetManager
   *          The asset manager.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public void setAssetManager(AssetManager assetManager);

}
